/******************************************************************************
*                                                  
*  (c) copyright Freescale Semiconductor 2008
*  ALL RIGHTS RESERVED
*
*  File Name: pit_main.c
*                                                                          
*  Purpose: Main application file for Bootloader demo
*                                                                          
*  Assembler:  Codewarrior for ColdFire V7.0
*                                            
*  Version:  1.1
*                                                                          
*                                                                          
*  Author: Derek Snell                             
*                                                                                       
*  Location: Indianapolis, IN. USA                                            
*                                                                                  
* UPDATED HISTORY:
*
* REV   YYYY.MM.DD  AUTHOR        DESCRIPTION OF CHANGE
* ---   ----------  ------        --------------------- 
* 1.1	2009.05.30	Derek Snell	  Modified to make application integration easier
* 1.0   2008.07.17  Derek Snell   Initial version
* 
*
******************************************************************************/                                                                        
/* Freescale  is  not  obligated  to  provide  any  support, upgrades or new */
/* releases  of  the Software. Freescale may make changes to the Software at */
/* any time, without any obligation to notify or provide updated versions of */
/* the  Software  to you. Freescale expressly disclaims any warranty for the */
/* Software.  The  Software is provided as is, without warranty of any kind, */
/* either  express  or  implied,  including, without limitation, the implied */
/* warranties  of  merchantability,  fitness  for  a  particular purpose, or */
/* non-infringement.  You  assume  the entire risk arising out of the use or */
/* performance of the Software, or any systems you design using the software */
/* (if  any).  Nothing  may  be construed as a warranty or representation by */
/* Freescale  that  the  Software  or  any derivative work developed with or */
/* incorporating  the  Software  will  be  free  from  infringement  of  the */
/* intellectual property rights of third parties. In no event will Freescale */
/* be  liable,  whether in contract, tort, or otherwise, for any incidental, */
/* special,  indirect, consequential or punitive damages, including, but not */
/* limited  to,  damages  for  any loss of use, loss of time, inconvenience, */
/* commercial loss, or lost profits, savings, or revenues to the full extent */
/* such  may be disclaimed by law. The Software is not fault tolerant and is */
/* not  designed,  manufactured  or  intended by Freescale for incorporation */
/* into  products intended for use or resale in on-line control equipment in */
/* hazardous, dangerous to life or potentially life-threatening environments */
/* requiring  fail-safe  performance,  such  as  in the operation of nuclear */
/* facilities,  aircraft  navigation  or  communication systems, air traffic */
/* control,  direct  life  support machines or weapons systems, in which the */
/* failure  of  products  could  lead  directly to death, personal injury or */
/* severe  physical  or  environmental  damage  (High  Risk Activities). You */
/* specifically  represent and warrant that you will not use the Software or */
/* any  derivative  work of the Software for High Risk Activities.           */
/* Freescale  and the Freescale logos are registered trademarks of Freescale */
/* Semiconductor Inc.                                                        */ 
/*****************************************************************************/

#include "support_common.h"
#include "bootloader_V2.h"


extern asm void asm_startmeup(void);


//***********************************************
// User Entry vectors for bootloader

const byte _UserEntry[] @ USER_ENTRY_ADDRESS = {
  0x4E,
  0x71,
  0x4E,
  0xF9           //asm NOP(0x4E71), asm JMP(0x4EF9)           
};

void  (* const _UserEntry2[])()@(USER_ENTRY_ADDRESS+4)=
{
  asm_startmeup,
};


/********************************************************************/
/* 
 * PIT0 ISR
 */
__declspec(interrupt) void pit0_isr(void)
{


    MCF_PIT0_PCSR |= MCF_PIT_PCSR_PIF;
    MCF_GPIO_PORTTC ^= 0x08;
    
}


/********************************************************************/
void main (void)
{

	// Set the interrupt handlers in the vector table 
	mcf5xxx_wr_vbr((uint32)__VECTOR_RAM);
	mcf5xxx_set_handler(64 + 55, (long)pit0_isr);
	
    // Enable Interrupts for PIT0 (55)
    MCF_INTC0_IMRH &= ~(MCF_INTC_IMRH_INT_MASK55);
    MCF_INTC0_IMRL &= ~(MCF_INTC_IMRL_MASKALL);
    MCF_INTC0_ICR55 = MCF_INTC_ICR_IL(3)|MCF_INTC_ICR_IP(4);
	
	/* Global interrupt enable */
	mcf5xxx_wr_sr(0x2000);
	
    MCF_GPIO_PTCPAR = 0x00; 	//set DTIN3 as GPIO
    MCF_GPIO_DDRTC = 0x08;		//set DTIN3 as output
    MCF_GPIO_PORTTC = 0x00;		//DTIN3 output low    
	

    MCF_PIT_PCSR(0) |= MCF_PIT_PCSR_PRE(8);
    MCF_PIT_PMR(0) = 0xA0;
            
    MCF_PIT_PCSR(0) |= MCF_PIT_PCSR_PIE;
    
    // Start PIT0
    MCF_PIT_PCSR(0) |= MCF_PIT_PCSR_EN;
    
	// Wait forever and blink LED
	while(1)
	{
	}
	
}

/********************************************************************/
	
